/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.world.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.hibiscus.naturespirit.world.feature.TurnipRootFeatureConfig;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6796;

public class TurnipRootFeature
extends class_3031<TurnipRootFeatureConfig> {
    public TurnipRootFeature(Codec<TurnipRootFeatureConfig> codec) {
        super(codec);
    }

    private static boolean hasSpaceForTree(class_5281 world, TurnipRootFeatureConfig config, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i <= config.requiredVerticalSpaceForTree; ++i) {
            mutable.method_10098(class_2350.field_11036);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (TurnipRootFeature.isAirOrWater(blockState, i, config.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAirOrWater(class_2680 state, int height, int allowedVerticalWaterForTree) {
        if (state.method_26215()) {
            return true;
        }
        int i = height + 1;
        return i <= allowedVerticalWaterForTree && state.method_26227().method_15767(class_3486.field_15517);
    }

    private static boolean generateTreeAndRoots(class_5281 world, class_2794 generator, TurnipRootFeatureConfig config, class_5819 random, class_2338.class_2339 mutablePos, class_2338 pos) {
        for (int i = 0; i < config.maxRootColumnHeight; ++i) {
            mutablePos.method_10098(class_2350.field_11036);
            if (!config.predicate.test((Object)world, (Object)mutablePos) || !TurnipRootFeature.hasSpaceForTree(world, config, (class_2338)mutablePos)) continue;
            class_2338 blockPos = mutablePos.method_10074();
            if (world.method_8316(blockPos).method_15767(class_3486.field_15518) || !world.method_8320(blockPos).method_51367()) {
                return false;
            }
            if (!((class_6796)config.feature.comp_349()).method_39644(world, generator, random, (class_2338)mutablePos)) continue;
            TurnipRootFeature.generateRootsColumn(pos, pos.method_10264() + i, world, config, random);
            return true;
        }
        return false;
    }

    private static void generateRootsColumn(class_2338 pos, int maxY, class_5281 world, TurnipRootFeatureConfig config, class_5819 random) {
        int i = pos.method_10263();
        int j = pos.method_10260();
        class_2338.class_2339 mutable = pos.method_25503();
        for (int k = pos.method_10264(); k < maxY; ++k) {
            TurnipRootFeature.generateRoots(world, config, random, i, j, mutable.method_10103(i, k, j));
        }
    }

    private static void generateRoots(class_5281 world, TurnipRootFeatureConfig config, class_5819 random, int x, int z, class_2338.class_2339 mutablePos) {
        int i = config.rootRadius;
        Predicate<class_2680> predicate = state -> state.method_26164(config.rootReplaceable);
        for (int j = 0; j < config.rootPlacementAttempts; ++j) {
            mutablePos.method_25504((class_2382)mutablePos, random.method_43048(i) - random.method_43048(i), 0, random.method_43048(i) - random.method_43048(i));
            if (predicate.test(world.method_8320((class_2338)mutablePos))) {
                world.method_8652((class_2338)mutablePos, config.rootStateProvider.method_23455(random, (class_2338)mutablePos), 2);
            }
            mutablePos.method_33097(x);
            mutablePos.method_33099(z);
        }
    }

    private static void generateHangingRoots(class_5281 world, TurnipRootFeatureConfig config, class_5819 random, class_2338 pos, class_2338.class_2339 mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.hangingRootPlacementAttempts; ++k) {
            class_2680 blockState;
            mutablePos.method_25504((class_2382)pos, random.method_43048(i) - random.method_43048(i), random.method_43048(j) - random.method_43048(j), random.method_43048(i) - random.method_43048(i));
            if (!world.method_22347((class_2338)mutablePos) || !(blockState = config.hangingRootStateProvider.method_23455(random, (class_2338)mutablePos)).method_26184((class_4538)world, (class_2338)mutablePos) || !world.method_8320(mutablePos.method_10084()).method_26206((class_1922)world, (class_2338)mutablePos, class_2350.field_11033)) continue;
            world.method_8652((class_2338)mutablePos, blockState, 2);
        }
    }

    private static void generateTurnips(class_5281 world, TurnipRootFeatureConfig config, class_5819 random, class_2338 pos, class_2338.class_2339 mutablePos) {
        int i = config.hangingRootRadius;
        int j = config.hangingRootVerticalSpan;
        for (int k = 0; k < config.turnipPlacementAttempts; ++k) {
            class_2680 blockState;
            mutablePos.method_25504((class_2382)pos, random.method_43048(i) - random.method_43048(i), random.method_43048(j) - random.method_43048(j), random.method_43048(i) - random.method_43048(i));
            if (world.method_8320(mutablePos.method_10079(class_2350.field_11036, 1)) != config.rootStateProvider.method_23455(random, (class_2338)mutablePos) || !(blockState = config.turnipStateProvider.method_23455(random, (class_2338)mutablePos)).method_26184((class_4538)world, (class_2338)mutablePos) || !world.method_8320(mutablePos.method_10084()).method_26206((class_1922)world, (class_2338)mutablePos, class_2350.field_11033)) continue;
            world.method_8652((class_2338)mutablePos, blockState, 2);
        }
    }

    public boolean method_13151(class_5821<TurnipRootFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 blockPos = context.method_33655();
        TurnipRootFeatureConfig turnipRootFeatureConfig = (TurnipRootFeatureConfig)context.method_33656();
        class_2338.class_2339 mutable = blockPos.method_25503();
        if (TurnipRootFeature.generateTreeAndRoots(structureWorldAccess, context.method_33653(), turnipRootFeatureConfig, random, mutable, blockPos)) {
            TurnipRootFeature.generateHangingRoots(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
            TurnipRootFeature.generateTurnips(structureWorldAccess, turnipRootFeatureConfig, random, blockPos, mutable);
        }
        return true;
    }
}

